<?php
/* --------------------------------------------------------------
   ParcelServiceIds.php 2020-02-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Model;

use ArrayIterator;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceId;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceIds as ParcelServiceIdsInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class ParcelServiceIds
 *
 * @package Gambio\Admin\ParcelService\Model
 */
class ParcelServiceIds implements ParcelServiceIdsInterface
{
    /**
     * @var ParcelServiceId[]
     */
    private $ids;
    
    
    /**
     * ParcelServiceIds constructor.
     *
     * @param array $ids
     */
    private function __construct(array $ids)
    {
        $this->ids = $ids;
    }
    
    
    /**
     * @param ParcelServiceId[] $ids
     *
     * @return ParcelServiceIds
     */
    public static function create(ParcelServiceId ...$ids): ParcelServiceIds
    {
        return new self($ids);
    }
    
    
    /**
     * @param ParcelServiceId[] $ids
     *
     * @return ParcelServiceIds
     */
    public static function createWithReferences(array $ids): ParcelServiceIds
    {
        Assert::allIsInstanceOf($ids,
                                ParcelServiceId::class,
                                'All IDs need to implement the "' . ParcelServiceId::class . '" interface.');
        
        return new self($ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function items(): array
    {
        return $this->ids;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return $this->items();
    }
}